package it.eng.eremita.jpa.manager;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import java.util.List;

import javax.ejb.LocalBean;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.enterprise.context.SessionScoped;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.Query;

import org.crygier.graphql.GraphQLSchemaBuilder;

import graphql.schema.GraphQLSchema;
import io.leangen.graphql.GraphQLSchemaGenerator;
import it.eng.eremita.graphql.types.Identifiable;
import it.eng.eremita.graphql.types.SessionProvider;
import it.eng.eremita.graphql.types.other.Pagination;
import it.eng.eremita.jpa.entity.Utente;

@Stateful
//@Stateless
@LocalBean
public class EremitaManager implements Serializable {

	
	@PersistenceContext(unitName = "LifeEremitaJPA",type=PersistenceContextType.EXTENDED)
	private EntityManager em;
	
	/*
	
	public Utente getUtenteLoggato() {
		return utenteLoggato;
	}

	public void setUtenteLoggato(Utente utenteLoggato) {
		this.utenteLoggato = utenteLoggato;
	}
	
	public boolean isUtenteEsistente(String cf) {
		Utente u = (Utente)getById(Utente.class, cf);
		return (u!=null && (u.getScadenzaAccount()==null || u.getScadenzaAccount().after(new Date())));
	}
	
	public void setUtenteLoggato(String cf) {
		Utente u = (Utente)getById(Utente.class, cf);
		utenteLoggato = u;
	}*/
	
	public boolean isUtenteEsistente(String cf) {
		Utente u = (Utente)getById(Utente.class, cf);
		return (u!=null && (u.getScadenzaAccount()==null || u.getScadenzaAccount().after(new Date())));
	}

	public long getCount(Class c) {
		return (long)em.createQuery("select count(x) from " +c.getSimpleName()+" x").getSingleResult();
	}
    
    public List getAll(Class c) {
    	return em.createQuery("select x from " +c.getSimpleName()+" x").getResultList();
    }
    
    public List getAll(Class c, Pagination p) {
    	return em.createQuery("select x from " +c.getSimpleName()+" x").setMaxResults(p.getLimit()).setFirstResult(p.getOffset()).getResultList();
    }
    
    public List getSql(Class c, String sql) {
    	return em.createNativeQuery(sql,c).getResultList();
    }
    
    public List getSql(Class c, String sql, Pagination p) {
    	return em.createNativeQuery(sql,c).setMaxResults(p.getLimit()).setFirstResult(p.getOffset()).getResultList();
    }
    
    public List getSql(Class c, String sql, List<Object> parameters, Pagination p) {
    	Query q = (c!=null? em.createNativeQuery(sql,c): em.createNativeQuery(sql));
    	if (p!=null) {
    		q = q.setMaxResults(p.getLimit()).setFirstResult(p.getOffset());
    	}
    	int index = 1;
    	if (parameters!=null)
    		for (Object o : parameters) q = q.setParameter(index++,o);
    	return q.getResultList();
    }
    
    public <X extends Object> X getSqlSingleResult(Class<X> c, String sql, List<Object> parameters) {
    	try {
	    	Query q =  (c!=null? em.createNativeQuery(sql,c): em.createNativeQuery(sql));
	    	int index = 1;
	    	if (parameters!=null)
	    		for (Object o : parameters) q = q.setParameter(index++,o);
	    	return (X)q.getSingleResult();
    	} catch (javax.persistence.NoResultException e) {
    		return null;
    	}
    }
    
    public Integer updateSql(String sql, List<Object> parameters) {
    	Query q =  em.createNativeQuery(sql);
    	int index = 1;
    	if (parameters!=null)
    		for (Object o : parameters) q = q.setParameter(index++,o);
    	return q.executeUpdate();
    }
    
    public <X extends Object>X getById(Class<X> c, Object id) {
    	try {
    	return em.find(c, id);
    	}
    	 catch (javax.persistence.NoResultException e) {
     		return null;
     	}
    }
    
    public <X extends Object>X update(X o) {
    	
    	if (o==null) return null;
    	
    	if (o instanceof Identifiable) {
    		Identifiable i = (Identifiable)o;
    		try {
    			X old = (i.getId()!=null? (X)em.find(o.getClass(), i.getId()) : null);
    			if (old!=null) {
    				notNullUpdater(o.getClass(),old,o);
    				return old;
    			} else o = em.merge(o);
    		} catch (Exception e) {
    			e.printStackTrace();
    		}
    	} else
    		o = em.merge(o);
    	
    	
    	return o;
    }
    
    public <X extends Object>X forceUpdate(X o) {
    	
    	if (o==null) return null;

    	o = em.merge(o);
    	return o;
    }
    
    public <X extends Object>X forceUpdateAndCommit(X o) {
    	
    	if (o==null) return null;

    	o = em.merge(o);
    	return o;
    }
    
    public <X extends Object>X updateAndCommit(X o) {
    	
    	//o = update(o);
    	o = em.merge(o);
    	em.flush();
    	return o;
    }
    
    public void delete(Object o) {
    	em.remove(o);
    }
    
    public boolean delete(Class c, Object id) {
    	Object o = em.find(c, id);
    	if (o!=null) {
    		em.remove(o);
    		return true;
    	} else return false;
    }
    
    public void deleteAndCommit(Object o) {
    	em.remove(o);
    	em.flush();
    }
    
    public boolean deleteAndCommit(Class c, Object id) {
    	boolean b = delete(c,id);
    	if (b) em.flush();
    	return b;
    }

    
    public static Class getEntityClass(Object o) {
    	Class c = o.getClass();
    	while(!c.equals(Object.class)) {
    		Annotation a[] =c.getAnnotations();
    		for (Annotation aa : a) 
    			if (aa instanceof javax.persistence.Entity) return c;
    		
    		c = c.getSuperclass();
    	}
    	return null;
    }
    
    public static Class getEntitySuperClass(Class o) {
    	Class c = o;
    	while(!c.equals(Object.class)) {
    		Annotation a[] =c.getAnnotations();
    		for (Annotation aa : a) 
    			if (aa instanceof javax.persistence.Entity) return c;
    		
    		c = c.getSuperclass();
    	}
    	return null;
    }
    
    private void notNullUpdater(Class c, Object oldObject, Object newObject) {
    	for (Method m : c.getMethods()) {
    		if (m.getName().startsWith("get")) {
    			Annotation a[] = m.getAnnotations();
    			boolean isId = false;
    			boolean isManagedCollection = false;
    			boolean process = false;
    			for (Annotation aa : a) {
    				if (aa instanceof javax.persistence.Id) isId = true;
    				if (aa instanceof javax.persistence.Column) process = true;
    				if (aa instanceof javax.persistence.JoinColumn) process = true;
    				if (aa instanceof javax.persistence.JoinTable) process = true;
    				if (aa instanceof javax.persistence.OneToMany) isManagedCollection = true;
    				if (aa instanceof javax.persistence.ManyToMany) isManagedCollection = true;
    			}
    			if (process && !isManagedCollection && !isId) {
    				// null?
    				try {
    					Object o = m.invoke(newObject);
    					if (o!=null) {
    						//cambia il nome in "set"
    						String setter = "s"+ m.getName().substring(1);
    						Method m2 = c.getMethod(setter, m.getReturnType());
    						if (m2!=null) {
    							m2.invoke(oldObject, o);
    						}
    					}
    				} catch (Exception e) {
    					e.printStackTrace();
    				}
    			}
    			
    			//per ora gestiamo i figli separatamente
    			/*if (process && isManagedCollection) {
    				// null?
    				try {
    					Object o = m.invoke(newObject);
    					if (o!=null) {
    						
    						Collection colNew = (Collection)o;
    						Collection colOld = (Collection)m.invoke(oldObject);
    						
    						if (colOld==null) {
    							//era null, sostituisci l'intera collezione
    							String setter = "s"+ m.getName().substring(1);
    							Method m2 = c.getMethod(setter, m.getReturnType());
    							if (m2!=null) {
        							m2.invoke(oldObject, o);
        						}
    						} else {
    							
    							for (Object oInNewCol : colNew) {
    								
    							}
    							
    						}

    					}
    				} catch (Exception e) {
    					e.printStackTrace();
    				}
    			}*/
    		}
    	}
    }
    
    
    public GraphQLSchema getGraphQLSchema(SessionProvider provider) {
    	it.eng.eremita.graphql.types.Query query = new it.eng.eremita.graphql.types.Query(provider);
    	it.eng.eremita.graphql.types.Mutation mutation = new it.eng.eremita.graphql.types.Mutation(provider);

    	GraphQLSchema schema = new GraphQLSchemaGenerator()
    			.withDefaults()
    		    .withOperationsFromSingletons(query,mutation) //register the service
    		    .generate(); //done ;)
    	
    	return schema;
    }
}
